#define proc nrtxproc
#include "nrtx/nrtxdb.h"
#include "nrtx/proc.h"

class NrtxMaster : public RtMaster {
protected:
	RtMaster *kernel;
	char	*kbd(char*);
	char	*help(long);
	void	open();
	void	refresh(int);
	void	kpi();
virtual	RtMaster *newDbmonMaster() = 0;
public:
	NrtxMaster(int f,int i,int p,RtNode* n): RtMaster(f, i, p, n) {}
};

class NrtxProcess : public Process {
	friend NrtxCore;
protected:
	int	fd;
	int	boardid;
	int	pipeid;
	int	procid;
	SigMask	*sigmsk;

	int	accept(Action);
	Index	carte();
	void	destroy();
	void	hang();
	void	hangopen();
	void	hangtakeover();
	void	opensigmask();
	void	substitute(NrtxProcess*);
	void	takeover();
	void	userclose();
virtual	Core *newCore(Master*) = 0;
public:
		NrtxProcess(int,int,int,Process*,char*,char*,char*);
	void	open();
};

class NrtxCore : virtual public Core {
	friend NrtxProcess;
protected:
	int		commfd;
	int		boardid;
	int		procid;
	int		pipeid;
	int		regsize;
	proc		pr;
	long		scratch;

	long	regaddr();
	long	scratchaddr();
	char	*dbreq(int, char* =0, int =0, int =0);
	Behavs	behavetype();
	char	*readwrite(long,char*,int,int);
	char	*dostep(long,long,int);
	int	nsig();
	int	exechangsupported();
	char	*signalsend(long);
	char	*signalmask(long);
	char	*signalclear();
	char	*exechang(long);
	char	*signalname(long);
	long	signalmaskinit();
public:
		NrtxCore(int,int,int,int);
	Behavs	behavs();
	char	*destroy();
	char	*run();
	char	*stop();
	char	*problem();
	char	*eventname();
	char	*readcontrol();
	char	*laybpt(Trap*);
	char	*open();
	char	*reopen(char*,char*);
};
